(defstruct task-environment (game-elements-list nil))

(defmethod device-move-cursor-to ((device task-environment) loc)
	(declare (ignore loc))
)

(defmethod device-handle-click ((device task-environment)))

(defmethod device-handle-keypress ((device task-environment) key)
	(declare (ignore key))
)

(defmethod cursor-to-vis-loc ((device task-environment)))

(defmethod get-mouse-coordinates ((device task-environment)) 
	(vector 0 0)
)

(defmethod build-vis-locs-for ((device task-environment) vision-mod)
	(declare (ignore vision-mod))
	;called as part of the proc-display
	;must return a list of visual location chunks
	(task-environment-update-display device)
	(mapcar 'car (task-environment-game-elements-list device))
)

(defmethod vis-loc-to-obj ((device task-environment) vis-loc)
	"Returns the visual object that corresponds to the specified visual location."
	(cdr (assoc vis-loc (task-environment-game-elements-list device)))
)

;; update the visual objects and visual locatin objects contained in the game-elements-list
(defun task-environment-update-display (device)
	(dolist (element-row (select *game-elements-db* (where :current t)))
		(task-environment-add-game-element-to-list device element-row))
)

(defun task-environment-add-game-element-to-list (device element-row)
	(setf (task-environment-game-elements-list device) (append (task-environment-game-elements-list device)  
			(task-environment-create-visual-objects-for-game-element element-row)))
)

(defun task-environment-create-visual-objects-for-game-element (element-row)
	(let* ((xpos-val (getf element-row :world-position-x))
			(ypos-val (getf element-row :world-position-y))
			(zpos-val (getf element-row :world-position-z))
			(height-val (getf element-row :height))
			(width-val (getf element-row :width))
			(world-distance-val (getf element-row :world-distance))
			(screen-x-val (getf element-row :screen-x))
			(screen-y-val (getf element-row :screen-y))
			(screen-width-val (getf element-row :screen-width))
			(screen-height-val (getf element-row :screen-height))
			(element-type-val (getf element-row :element-type))
			(element-color-val (getf element-row :element-color))
			(object-chunk-list `(isa game-element 
						world-position-x ,xpos-val
						world-position-y ,ypos-val
						world-position-z ,zpos-val
						element-height ,height-val
						element-width ,width-val
						world-distance ,world-distance-val
						screen-x ,screen-x-val
						screen-y ,screen-y-val
						screen-width ,screen-width-val
						screen-height ,screen-height-val
						element-type ,element-type-val
						element-color ,element-color-val))
			(location-chunk-list `(isa visual-location screen-x ,screen-x-val screen-y ,screen-y-val kind game-element value ,element-type-val 
										height ,screen-height-val width ,screen-width-val color ,element-color-val))
			(new-list-element nil)
			(location-chunk (define-chunks-fct (list location-chunk-list)))
			(object-chunk (define-chunks-fct (list object-chunk-list))))
		(setf new-list-element (pairlis location-chunk object-chunk))
		new-list-element)
)